package com.burhanstore.neonbubblequest.act

import android.app.Activity
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.adapter.TrackAdapterAll
import com.burhanstore.neonbubblequest.Utils.anim.setClick
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.Utils.model.DB_Track
import com.burhanstore.neonbubblequest.Utils.network.AppNetworkAdapter
import com.burhanstore.neonbubblequest.Utils.response.TrackResponse
import com.burhanstore.neonbubblequest.databinding.ActivityEarnHactivityBinding
import com.google.gson.Gson
import com.google.gson.JsonObject
import kotlinx.coroutines.launch

class EarnHActivity : AppCompatActivity() {
    private lateinit var binding: ActivityEarnHactivityBinding
    private lateinit var activity: Activity

    private var uid: String = ""
    private lateinit var user_m: UserManager

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityEarnHactivityBinding.inflate(layoutInflater)
        setContentView(binding.root)
        activity = this


        DialogManager.initDialog(activity)
        DialogManager.showDialog()
        binding.imageView2.setClick { finish() }
        user_m = UserManager.Companion.getInstance(activity)
        uid = user_m.getUser()?.u_id ?: ""
        get_data()


    }

    private fun get_data() {

        val json = JsonObject().apply {
            addProperty("action", "get_earnhistory")
            addProperty("u_id", uid)
        }
        AppNetworkAdapter.sendRequest(
            lifecycleScope,
            json,
            object : AppNetworkAdapter.ResponseHandler {
                override fun onSuccess(response: JsonObject?) {
                    Log.d("QuickBonus", "Success: $response")

                    lifecycleScope.launch {
                        try {
                            val quickBonusResponse =
                                Gson().fromJson(response, TrackResponse::class.java)
                            val trackList = quickBonusResponse.track ?: emptyList()
                            update_track(trackList)
                            DialogManager.dismissDialog()

                        } catch (e: Exception) {
                            Log.e("QuickBonus", "Parsing error: ${e.message}")
                        }
                    }
                }

                override fun onError(code: Int, message: String?) {
                    Log.e("QuickBonus", "Error $code: $message")
                }

                override fun onException(exception: Exception) {
                    Log.e("QuickBonus", "Exception: ", exception)
                }
            }
        )

    }


    private fun update_track(trackList: List<DB_Track>) {

        if (trackList.isEmpty()) {
            binding.ly2.visibility = View.VISIBLE
            return
        }

        val trackAdapter = TrackAdapterAll(this, trackList) { selectedItem ->
        }

        binding.trackList.layoutManager = LinearLayoutManager(this)
        binding.trackList.adapter = trackAdapter
        binding.trackList.visibility = View.VISIBLE
        binding.ly2.visibility = View.VISIBLE

    }


}